/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.model;

import frc.emul.api.engine.IDebugMemory;
import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.api.engine.IEngineBreakpointListener;
import frc.emul.api.engine.IEngineBreakpointManager;
import frc.emul.debug.breakpoints.MemoryBreakpoint;
import frc.emul.vectrex.VectrexMemory;
import java.util.ArrayList;
import java.util.List;

public class DebugMemory
extends VectrexMemory
implements IDebugMemory,
IEngineBreakpointListener {
    private List<MemoryBreakpoint> bkpts = new ArrayList<MemoryBreakpoint>();
    private volatile boolean checkNeeded;
    private volatile boolean monitoring;

    public int readS8(int n) {
        if (this.checkNeeded) {
            this.checkReadAccess8(n);
        }
        return super.readS8(n);
    }

    public int readU8(int n) {
        if (this.checkNeeded) {
            this.checkReadAccess8(n);
        }
        return super.readU8(n);
    }

    public void write8(int n, int n2) {
        if (this.checkNeeded) {
            this.checkWriteAccess8(n);
        }
        super.write8(n, n2);
    }

    public int readS16(int n) {
        if (this.checkNeeded) {
            this.checkReadAccess16(n);
        }
        return super.readS16(n);
    }

    public int readU16(int n) {
        if (this.checkNeeded) {
            this.checkReadAccess16(n);
        }
        return super.readU16(n);
    }

    public void write16(int n, int n2) {
        if (this.checkNeeded) {
            this.checkWriteAccess16(n);
        }
        super.write16(n, n2);
    }

    public final synchronized void setMonitoringBreakpoints(boolean bl) {
        this.monitoring = bl;
        this.checkNeeded = bl && !this.bkpts.isEmpty();
    }

    public final boolean isMonitoringBreakpoints() {
        return this.monitoring;
    }

    public final synchronized void breakpointsListChanged(IEngineBreakpointManager iEngineBreakpointManager) {
        this.bkpts.clear();
        List<IEngineBreakpoint> list = iEngineBreakpointManager.getBreakpoints();
        for (IEngineBreakpoint iEngineBreakpoint : list) {
            this.breakpointCreated(iEngineBreakpoint);
        }
    }

    public final synchronized void breakpointCreated(IEngineBreakpoint iEngineBreakpoint) {
        if (iEngineBreakpoint instanceof MemoryBreakpoint) {
            this.bkpts.add((MemoryBreakpoint)iEngineBreakpoint);
            this.checkNeeded = this.monitoring;
        }
    }

    public final synchronized void breakpointDeleted(IEngineBreakpoint iEngineBreakpoint) {
        if (this.bkpts.remove(iEngineBreakpoint)) {
            this.checkNeeded = this.monitoring && !this.bkpts.isEmpty();
        }
    }

    public final synchronized void breakpointModified(IEngineBreakpoint iEngineBreakpoint) {
    }

    private final synchronized void checkReadAccess8(int n) {
        List<MemoryBreakpoint> list = this.bkpts;
        int n2 = list.size();
        while (n2-- > 0) {
            list.get(n2).check(n, 1, false);
        }
    }

    private final synchronized void checkWriteAccess8(int n) {
        List<MemoryBreakpoint> list = this.bkpts;
        int n2 = list.size();
        while (n2-- > 0) {
            list.get(n2).check(n, 1, true);
        }
    }

    private final synchronized void checkReadAccess16(int n) {
        List<MemoryBreakpoint> list = this.bkpts;
        int n2 = list.size();
        while (n2-- > 0) {
            list.get(n2).check(n, 2, false);
        }
    }

    private final synchronized void checkWriteAccess16(int n) {
        List<MemoryBreakpoint> list = this.bkpts;
        int n2 = list.size();
        while (n2-- > 0) {
            list.get(n2).check(n, 2, true);
        }
    }
}

